﻿unit Tracking_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const

  Array_Items_TRK_IOS_1: TSQL_Table_array = (
   (sql_col: 'DNT_ZTIME';          fex_col: 'Timestamp';            read_as: ftFloat;         convert_as: 'ABS';        col_type: ftDateTime;     show: True),
   (sql_col: 'DNT_ZNAME';          fex_col: 'Waypoint Name';        read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_ZDESC';          fex_col: 'Waypoint Description'; read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_ZELEVATION';     fex_col: 'Elevation';            read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_ZLATITUDE';      fex_col: 'Latitude';             read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_ZLONGITUDE';     fex_col: 'Longitude';            read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
   (sql_col: 'DNT_SQLLOCATION';    fex_col: 'Location';             read_as: ftString;        convert_as: '';           col_type: ftString;       show: True),
  );

    Array_Items_NULL: TSQL_Table_array = (
    (sql_col: '';
    fex_col: '';
    read_as: ftString;
    convert_as: '';
    col_type: ftString;
    show: false));    

begin
  if Name = 'TRK_IOS_1' then Result := Array_Items_TRK_IOS_1 else
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('Tracking' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
